// typedef section contains the actual functions definitions
typedef struct r256
{
  char A[256];
} R256;
typedef struct r32
{
  char A[32];
} R32;
typedef struct r16
{
  char A[32];
} R16;

typedef struct delphiDevRec
{
  DWORD USBInstance;
  DWORD USBVersion;
  DWORD DevID;
  DWORD EEID;
} DeviceRec;
typedef struct delphiIEE
{
  DWORD USBVendorID;
  DWORD USBProductID;
  DWORD USBDeviceID;
  DWORD DeviceID;
  DWORD EEPromID;
  DWORD Version;
  DWORD SerialNumber;
  DWORD CustomerID;
  char  Company[32];
  char  Date[32];
  char  ProductStr[32];
  char  Customer[32];
  char  CustomerStr[32];
} USBEEProm;

// instant termination of any movement
typedef  void  (_stdcall*  pCU30Stop)   (	DeviceRec devRec );
typedef  void  (_stdcall*  pCU30Open)   (	R256 * result, DeviceRec * pdevRec );
typedef  void  (_stdcall*  pCU30Close)  (	DeviceRec devRec );

typedef  void  (_stdcall*  pCU30Sweep)  (	DeviceRec MUSBDeviceID, long lAxis, long lSpeed, long lTimeout);

typedef  void  (_stdcall*  pCU30Step)   (	DeviceRec MUSBDeviceID, long lAxis, long lSpeed, long lSteps);           
// switch DCDC-converter on, required for operation
typedef  void  (_stdcall*  pCU30DCDCon) (	DeviceRec devRec );
// switch DCDC-converter off
typedef  void  (_stdcall*  pCU30DCDCoff)(	DeviceRec devRec );

typedef  void  (_stdcall*  pGetUSBEEPromInfo)   (USBEEProm * result,	DeviceRec devRec );
typedef  DWORD (_stdcall*  pEcho)(DeviceRec devRec, DWORD w);
typedef  DWORD (_stdcall*  pCU30TestReady)( DeviceRec devRec);

class USBdllLoader : public DllLoader
{
  public:
    USBdllLoader();
    ~USBdllLoader();
    void Connect();
  private:
    // Function status structures
    ImportedFunc ifCU30Stop; 
    ImportedFunc ifCU30Open;     
    ImportedFunc ifCU30Close;     
    ImportedFunc ifGetUSBEEPromInfo;
    ImportedFunc ifCU30Sweep;
    ImportedFunc ifCU30Step;
    ImportedFunc ifCU30DCDCon;
    ImportedFunc ifCU30DCDCoff;
    ImportedFunc ifEcho;
    ImportedFunc ifTestReady;
    R256 tempR;
  public: 
    // function prototypes
    bool CU30Stop(DeviceRec devRec);
    bool CU30Open(DeviceRec * pdevRec, char ** refStr);    
    bool CU30Close(DeviceRec devRec);
    bool CU30Sweep(DeviceRec MUSBDeviceID, int Vel, int Axis, int Timeout);
    bool CU30Step(DeviceRec MUSBDeviceID, int Axis, int n, int Vel);           
    bool CU30DCDCon(DeviceRec devRec);
    bool CU30DCDCoff(DeviceRec devRec);
    USBEEProm GetUSBEEPromInfo(DeviceRec devRec);
    DWORD CU30Echo(DeviceRec devRec, WORD w);
    DWORD CU30TestReady(DeviceRec devRec);
};

